<?php

namespace Modules\WooCommerce\Jobs;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use Carbon\Carbon;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\WooCommerce\ApiDataTransferObjects\WooCommerceGetOrdersAdt;
use Modules\WooCommerce\Data\WooCommerceResponseData;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceOrder;
use Modules\WooCommerce\Jobs\Abstractions\WooCommerceJob;
use Modules\WooCommerce\Managers\WooCommerceOrderManager;
use Modules\WooCommerce\Repositories\WooCommerceOrderRepository;

class RefreshWooCommerceOrdersJob extends WooCommerceJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    public function __construct(
        protected WooCommerceIntegrationInstance $wooCommerceIntegrationInstance,
        protected WooCommerceGetOrdersAdt $parameters,
    ) {
        $this->uniqueId = get_class($this).':'.$this->wooCommerceIntegrationInstance->id;
    }

    /**
     * @throws Exception
     */
    public function apiCall(): WooCommerceResponseData|ClientResponseDataInterface
    {
        $this->parameters->nextPage = @$this->jobPayload['nextPage'];

        // If no records yet, use the created after parameter
        if (WooCommerceOrder::where('integration_instance_id', $this->wooCommerceIntegrationInstance->id)->count() === 0) {
            $this->parameters->after = app(WooCommerceOrderRepository::class)->getStartDateForNew($this->wooCommerceIntegrationInstance);
        } elseif ($modifiedAfter = @$this->jobPayload['modifiedAfterDateTime']) {
            $this->parameters->modified_after = Carbon::parse($modifiedAfter); // we need to avoid sanitizeDates because this is already in UTC
        }

        return (new WooCommerceOrderManager($this->wooCommerceIntegrationInstance))->refreshOrders($this->parameters);
    }
}
