<?php

namespace Modules\WooCommerce\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\WooCommerce\Entities\WooCommerceOrder;
use Modules\WooCommerce\Entities\WooCommerceProduct;

/**
 *
 * @mixin WooCommerceProduct|array
 */
class SalesOrderLineListingWooCommerceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $wooCommerceOrder = WooCommerceOrder::find($this->resource->woo_commerce_order_id);
        return [
            'id' => $this['id'],
            'product_id' => @$this['product_id'] ?? null,
            'unique_sales_channel_product_id' => $this['product_id'],
            'skuAlias' => $this['sku'],
            'sku' => $this['sku'],
            'title' => $this['name'],
            'shop_url' => $wooCommerceOrder->integrationInstance->integration_settings['url'],
            'quantity' => $this['quantity'],
            'amount' => $this['json_object']['subtotal'],
            'tax_allocation' => $this['json_object']['total_tax'],
        ];
    }
}
