<?php

namespace Modules\WooCommerce\Http\Controllers;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelOrderController;
use App\Data\CreateSkuOrderFromSalesChannelData;
use App\Exceptions\ExportingEmptyDataException;
use App\Response;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceOrder;
use Modules\WooCommerce\Http\Resources\WooCommerceOrderResource;
use Modules\WooCommerce\Jobs\RefreshWooCommerceOrdersJob;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Throwable;

class WooCommerceOrderController extends AbstractSalesChannelOrderController
{
    protected function getModel(): string
    {
        return WooCommerceOrder::class;
    }

    protected function getResource(): string
    {
        return WooCommerceOrderResource::class;
    }

    // Typehint $integrationInstance with the integration implementation
    public function indexForIntegration(Request $request, WooCommerceIntegrationInstance $integrationInstance)
    {
        return $this->abstractIndexForIntegration($request, $integrationInstance);
    }

    // Typehint $order with the integration implementation
    function show(WooCommerceIntegrationInstance $integrationInstance, WooCommerceOrder $order)
    {
        return $this->abstractShow($order);
    }

    public function refresh(WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefresh(new RefreshWooCommerceOrdersJob($integrationInstance, app($this->getModel())->refreshAdt()));
    }

    public function refreshOrder(Request $request, WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefreshOrder($request, $integrationInstance);
    }

    /**
     * Typehint $integrationInstance with the integration implementation
     *
     * @throws Throwable
     */
    public function createSkuOrders(CreateSkuOrderFromSalesChannelData $data, WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractCreateSkuOrders($data, $integrationInstance);
    }

    /**
     * @throws ExportingEmptyDataException
     */
    protected function exportForIntegration(Request $request, WooCommerceIntegrationInstance $integrationInstance): BinaryFileResponse|Response|RedirectResponse
    {
        return $this->abstractExportForIntegration($request, $integrationInstance);
    }
}
