<?php

namespace Modules\WooCommerce\Http\Controllers;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelIntegrationInstanceController;
use App\DataTable\DataTable;
use App\Response;
use Illuminate\Contracts\Queue\ShouldQueue;
use Modules\WooCommerce\ApiDataTransferObjects\WooCommerceGetOrdersAdt;
use Modules\WooCommerce\ApiDataTransferObjects\WooCommerceGetProductsAdt;
use Modules\WooCommerce\Data\StoreWooCommerceIntegrationData;
use Modules\WooCommerce\Data\UpdateWooCommerceIntegrationData;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Http\Resources\WooCommerceIntegrationInstanceResource;
use Modules\WooCommerce\Jobs\RefreshWooCommerceOrdersJob;
use Modules\WooCommerce\Jobs\RefreshWooCommerceProductsJob;
use Modules\WooCommerce\Repositories\WooCommerceIntegrationInstanceRepository;
use Modules\WooCommerce\Services\WooCommerceClient;
use Throwable;

class WooCommerceIntegrationInstanceController extends AbstractSalesChannelIntegrationInstanceController
{
    use DataTable;

    protected WooCommerceIntegrationInstanceRepository $integrationInstanceRepository;

    public function __construct()
    {
        $this->integrationInstanceRepository = app(WooCommerceIntegrationInstanceRepository::class);

        parent::__construct();
    }

    public function show(WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractShow($integrationInstance);
    }

    /**
     * @throws Throwable
     */
    public function store(StoreWooCommerceIntegrationData $data): Response
    {
        $response = parent::abstractStore($data);

        $integrationInstance = $response->getOriginalData();

        return $response->setStatus(201)->addAdditional(
            'redirect_url',
            (new WooCommerceClient($integrationInstance))->getRedirectUrl()
        );
    }

    public function update(UpdateWooCommerceIntegrationData $data, WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return parent::abstractUpdate($data, $integrationInstance)->response;
    }

    /**
     * @throws Throwable
     */
    public function destroy(WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return parent::abstractDestroy($integrationInstance);
    }

    protected function getModel(): string
    {
        return WooCommerceIntegrationInstance::class;
    }

    protected function getResource(): string
    {
        return WooCommerceIntegrationInstanceResource::class;
    }
}
