<?php

namespace Modules\WooCommerce\Exceptions;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Enums\IntegrationInstanceSyncStatusEnum;
use App\Managers\IntegrationInstanceManager;
use Exception;

class WooCommerceReauthorizeException extends Exception
{
    public function __construct(protected IntegrationInstanceInterface $integrationInstance)
    {
        app(IntegrationInstanceManager::class)->updateSyncStatus($integrationInstance, IntegrationInstanceSyncStatusEnum::INACTIVE);

        parent::__construct('Woocommerce must be reauthorized.');
    }
}
