<?php

namespace Modules\WooCommerce\Entities;

use App\Models\Integration;
use Illuminate\Database\Eloquent\Builder;

class WooCommerceIntegration extends Integration
{
    protected $table = 'integrations';

    protected $primaryKey = 'id';

    protected static function booted(): void
    {
        static::addGlobalScope('woo-commerce', function (Builder $query) {
            $query->where('name', Integration::NAME_WOOCOMMERCE);
        });
    }
}
