<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('woo_commerce_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained();
            $table->string('woo_commerce_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.id'))");
            $table->string('sku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sku'))");
            $table->string('name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.name'))");
            $table->string('slug')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.slug'))");
            $table->string('type')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.type'))");
            $table->string('status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.status'))");
            $table->decimal('price', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.price'))");
            $table->string('weight', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.weight'))");
            $table->string('dimensions_length', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.dimensions.length'))");
            $table->string('dimensions_width', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.dimensions.width'))");
            $table->string('dimensions_height', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.dimensions.height'))");
            $table->string('featured')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.featured'))");
            $table->string('catalog_visibility')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.catalog_visibility'))");
            $table->string('date_created_gmt')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.date_created_gmt'))");
            $table->string('date_modified_gmt')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.date_modified_gmt'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('woo_commerce_products');
    }
};
