<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('woo_commerce_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained();
            $table->string('woo_commerce_id')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.id'))")->index();
            $table->string('number')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.number'))")->index();
            $table->string('status')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.status'))");
            $table->string('currency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.currency'))");
            $table->string('date_modified_gmt')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.date_modified_gmt'))");
            $table->string('date_created_gmt')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.date_created_gmt'))");
            $table->string('total')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.total'))");
            $table->string('total_tax')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.total_tax'))");
            $table->json('json_object');

            // There might be multiple WooCommerce installations with overlapping IDs, that is why the composite constraint is being used here
            $table->unique(['woo_commerce_id', 'integration_instance_id'], 'woo_commerce_orders_woo_commerce_id_composite_unique'); // Name must be less than 64 chars

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('woo_commerce_orders');
    }
};
