<?php

namespace Modules\WooCommerce\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceOrder;

class WooCommerceOrderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = WooCommerceOrder::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var WooCommerceIntegrationInstance $wooCommerceIntegrationInstance */
        $wooCommerceIntegrationInstance = WooCommerceIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $wooCommerceIntegrationInstance->id,
            'json_object' => [
                'id' => $this->faker->unique()->numberBetween(1, 2000),
                'number' => $this->faker->unique()->numberBetween(1, 2000),
                'status' => $this->faker->word(),
                'currency' => $this->faker->randomElement(['USD']),
                'date_completed_gmt' => Carbon::now()->toDateTimeString(),
                'date_created_gmt' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toDateTimeString(),
                'date_modified_gmt' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toDateTimeString(),
                'needs_payment' => false,
                'total' => $this->faker->randomFloat(2, 0, 100),
                'total_tax' => $this->faker->randomFloat(2, 0, 100),
                'billing' => [
                    'first_name' => $this->faker->firstName(),
                    'last_name' => $this->faker->lastName(),
                    'email' => $this->faker->email(),
                    'postcode' => $this->faker->postcode(),
                    'address_1' => $this->faker->address(),
                    'address_2' => $this->faker->address(),
                    'city' => $this->faker->city(),
                    'state' => $this->faker->state(),
                    'country' => $this->faker->country(),
                    'company' => $this->faker->company(),
                ],
                'shipping' => [
                    'first_name' => $this->faker->firstName(),
                    'last_name' => $this->faker->lastName(),
                    'email' => $this->faker->email(),
                    'postcode' => $this->faker->postcode(),
                    'address_1' => $this->faker->address(),
                    'address_2' => $this->faker->address(),
                    'city' => $this->faker->city(),
                    'state' => $this->faker->state(),
                    'country' => $this->faker->country(),
                    'company' => $this->faker->company(),
                ],
            ],
        ];
    }
}
