<?php

namespace Modules\WooCommerce\Data;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use App\Abstractions\Integrations\Data\AbstractSalesChannelData;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class WooCommerceResponseData extends Data implements ClientResponseDataInterface
{
    public function __construct(
        #[DataCollectionOf(AbstractSalesChannelData::class)]
        public DataCollection $collection,
        public Optional|int|null $nextPage,
        public Optional|string|null $modifiedAfterDateTime,
    ) {

    }
}
