<?php

namespace Modules\WooCommerce\Data;

use App\Abstractions\Integrations\Data\SalesChannelIntegrationSettingsData;
use App\Data\SalesChannelInventorySettingsData;
use App\Data\SalesChannelPricingSettingsData;
use Spatie\LaravelData\Attributes\Validation\DoesntEndWith;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\StartsWith;
use Spatie\LaravelData\Attributes\Validation\Url;
use Spatie\LaravelData\Optional;

class WooCommerceIntegrationSettingsData extends SalesChannelIntegrationSettingsData
{
    public function __construct(
        #[Url]#[DoesntEndWith('/')]#[StartsWith('https://')]
        public string $url,
        public string $start_date,
        #[Exists('stores', 'id')]
        public int $store_id,
        public bool $auto_link_products,
        public bool $auto_create_products,
        public ?int $sales_nominal_code_id,
        #[Exists('nominal_codes', 'id')]
        public ?int $cogs_nominal_code_id,
        public SalesChannelPricingSettingsData|Optional $pricing,
        public SalesChannelInventorySettingsData|Optional $inventory,
        public bool $emailCustomers = false,
        public ?float $proforma_marketplace_cost_percentage = null,
        public ?float $proforma_payment_cost_percentage = null,
        public bool $sync_sales_order_invoices_to_accounting = true
    )
    {
        // Always false for Amazon
        $this->emailCustomers = false;
        parent::__construct(
            $start_date,
            $store_id,
            $auto_link_products,
            $auto_create_products,
            $sales_nominal_code_id,
            $cogs_nominal_code_id,
            $pricing,
            $inventory,
            $emailCustomers,
            $proforma_marketplace_cost_percentage,
            $proforma_payment_cost_percentage,
            $sync_sales_order_invoices_to_accounting
        );
    }
}
