<?php

namespace Modules\WooCommerce\Data;

use Carbon\CarbonImmutable;
use Modules\WooCommerce\Services\DateTimeHelper;
use Modules\WooCommerce\Services\Exceptions\DateTimeHelperException;
use Spatie\LaravelData\Casts\Cast;
use Spatie\LaravelData\Casts\Uncastable;
use Spatie\LaravelData\Support\DataProperty;

/**
 * NOTE: this cast should be used on fields such as date_created_gmt and date_modified_gmt.
 *
 * It should not be used on date_created or date_modified
 */
class WooCommerceDateTimeCast implements Cast
{
    public function cast(DataProperty $property, mixed $value, array $context): CarbonImmutable
    {
        try {
            return DateTimeHelper::dateTimeStringToObject($value);
        } catch (DateTimeHelperException $e) {
            return Uncastable::create();
        }
    }
}
