<?php

namespace Modules\WooCommerce\Data;

use App\Abstractions\Integrations\Data\StoreSalesChannelIntegrationDataInterface;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class UpdateWooCommerceIntegrationData extends Data implements StoreSalesChannelIntegrationDataInterface
{
    public function __construct(
        public string|Optional $name,
        public WooCommerceConnectionSettingsData|Optional $connection_settings,
        public WooCommerceIntegrationSettingsData|Optional $integration_settings,
        public bool|Optional $is_automatic_sync_enabled = false,
    )
    {
    }
}