<?php

namespace Modules\WooCommerce\Console;

use Illuminate\Console\Command;
use Modules\WooCommerce\ApiDataTransferObjects\WooCommerceGetOrdersAdt;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Jobs\RefreshWooCommerceOrdersJob;
use Modules\WooCommerce\Repositories\WooCommerceIntegrationInstanceRepository;

class RefreshWooCommerceOrdersCommand extends Command
{
    public function __construct(private readonly WooCommerceIntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'woo-commerce:orders:refresh {--lastUpdatedAfter=} {--days=} {--integrationInstanceId=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh Woocommerce Orders';

    public function handle(): void
    {
        if ($this->option('integrationInstanceId')) {
            $query = $this->integrationInstanceRepository->all($this->option('integrationInstanceId'));
        } else {
            $query = $this->integrationInstanceRepository->all();
        }

        $parameters = new WooCommerceGetOrdersAdt(
            modified_after: $this->option('lastUpdatedAfter'),
            days: $this->option('days'),
        );

        $query
            ->each(function (WooCommerceIntegrationInstance $wooCommerceIntegrationInstance) use ($parameters) {
                RefreshWooCommerceOrdersJob::dispatch(
                    $wooCommerceIntegrationInstance,
                    $parameters,
                );
            });
    }
}
