<?php

namespace Modules\WooCommerce\Console;

use Exception;
use Illuminate\Console\Command;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Jobs\CreateSkuOrdersFromWooCommerceJob;
use Modules\WooCommerce\Repositories\WooCommerceIntegrationInstanceRepository;

class CreateSkuOrdersFromWooCommerceCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'woo-commerce:orders:create-sku-orders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create SKU orders from WooCommerce';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(private readonly WooCommerceIntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws Exception
     */
    public function handle(): void
    {
        $this->integrationInstanceRepository
            ->all()
            ->each(function (WooCommerceIntegrationInstance $wooCommerceIntegrationInstance) {
                dispatch(new CreateSkuOrdersFromWooCommerceJob($wooCommerceIntegrationInstance));
            });
    }
}
