<?php

namespace Modules\WooCommerce\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Carbon\CarbonImmutable;
use Modules\WooCommerce\ApiDataTransferObjects\Concerns\WooCommerceDatesTrait;

class WooCommerceGetProductsAdt implements ApiDataTransformerInterface
{
    use WooCommerceDatesTrait;

    public function __construct(
        public CarbonImmutable|null|string $modified_after = null,
        public ?string $nextPage = null,
    ) {
    }

    public function transform(): array
    {
        $params = [
            'modified_after' => $this->modified_after ? Carbon::parse($this->modified_after)->toIso8601ZuluString() : null,
            'page' => $this->nextPage,
            'per_page' => '100',
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
