<?php

namespace Modules\WooCommerce\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\SalesOrderFulfillment;
use Modules\WooCommerce\Entities\WooCommerceOrder;
use Modules\WooCommerce\Enums\WooCommerceOrderStatusEnum;

class WooCommerceFulfillOrderAdt implements ApiDataTransformerInterface
{

    public function __construct(
        public SalesOrderFulfillment $salesOrderFulfillment,
        public ?string $wooCommerceOrderId = null,
        public ?string $trackingNumber = null,
    )
    {}

    public function transform(): array
    {
        /** @var WooCommerceOrder $wooCommerceOrder */
        $wooCommerceOrder = $this->salesOrderFulfillment->salesOrder->salesChannelOrder;
        $this->wooCommerceOrderId = $wooCommerceOrder->{WooCommerceOrder::getTableUniqueId()};
        $this->trackingNumber = $this->salesOrderFulfillment->tracking_number;

        return [
            'status' => WooCommerceOrderStatusEnum::COMPLETED->value,
        ];
    }
}