<?php

namespace Modules\WooCommerce\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;

class WooCommerceAuthorizationAdt implements ApiDataTransformerInterface
{
    public function __construct(
        public IntegrationInstanceInterface $integrationInstance,
    ) {
    }

    public function transform(): array
    {
        $params = [
            'app_name' => config('app.name'),
            'scope' => config('woo_commerce.scope'),
            'user_id' => config('app.url').'_'.$this->integrationInstance->id,
            'return_url' => config('app.url').'/integrations/woocommerce/'.$this->integrationInstance->id.'/dashboard',
            'callback_url' => config('woo_commerce.callbackUrl'),
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
