<?php

namespace Modules\Veracore\Tests;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Models\User;
use App\Models\Warehouse;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Queue;
use Laravel\Sanctum\Sanctum;
use Tests\TestCase;
use Illuminate\Foundation\Testing\WithFaker;

class VeracoreTest extends TestCase
{

    use WithFaker;

    protected function setUp(): void
    {
        parent::setUp();
        Queue::fake();

        Sanctum::actingAs(User::factory()->create(['is_power_user' => true]));

        $integration = Integration::query()->where('name',Integration::NAME_VERACORE)->first();
        $warehouse = Warehouse::factory()->create(['type' => Warehouse::TYPE_3PL]);

        // Create the Veracore integration
        IntegrationInstance::factory()->create([
            'name' => Integration::NAME_VERACORE,
            'connection_settings' => [
                'username' => $this->faker->md5(),
                'password' => $this->faker->md5(),
                'systemId' => $this->faker->word()
            ],
            'integration_id' => $integration ? $integration->id : Integration::factory()->create([
                'name' => Integration::NAME_VERACORE,
                'integration_type' => Integration::TYPE_SHIPPING_PROVIDER
            ]),
            'integration_settings' => [
                'linked_warehouse_id' => $warehouse->id,
            ]
        ]);

        // Ensure that all external api requests are mocked.
        Http::preventStrayRequests();

    }
}
