<?php

namespace Modules\Veracore\Tests\Feature;

use App\Models\Integration;
use App\Models\User;
use App\Models\Warehouse;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Testing\Fluent\AssertableJson;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class VeracoreSetupTest extends TestCase
{
    use WithFaker;
    use FastRefreshDatabase;

    protected function makeWarehouseAndIntegration(): array
    {

        Sanctum::actingAs(User::factory()->create(['is_power_user' => 1]));

        $integration = Integration::query()->firstOrCreate(
            ['name' => Integration::NAME_VERACORE],
            ['integration_type' => Integration::TYPE_SHIPPING_PROVIDER]
        );
        $warehouse = Warehouse::factory()->create(['type' => Warehouse::TYPE_3PL]);
        return [$warehouse, $integration];
    }

    public function test_it_can_convert_direct_warehouse_to_3pl_when_linked_to_veracore(){

        [$warehouse, $integration] = $this->makeWarehouseAndIntegration();

        $this->postJson('/api/integration-instances', [
            'integration_id' => $integration->id,
            'name' => Integration::NAME_VERACORE,
            'integration_settings' => [
                'connectionName' => Integration::NAME_VERACORE,
                'linked_warehouse_id' => $warehouse->id,
            ],
            'connection_settings' => [
                'username' => $this->faker->word(),
                'password' => $this->faker->md5(),
                'systemId' => $this->faker->word()
            ]
        ])->assertSuccessful();

        $this->assertDatabaseHas('warehouses', [
            'id' => $warehouse->id,
            'type' => Warehouse::TYPE_3PL
        ]);

    }

    public function test_it_can_setup_veracore_with_3pl_warehouse(){

        [$warehouse, $integration] = $this->makeWarehouseAndIntegration();

        $response = $this->postJson('/api/integration-instances', [
            'integration_id' => $integration->id,
            'name' => Integration::NAME_VERACORE,
            'integration_settings' => [
                'connectionName' => Integration::NAME_VERACORE,
                'linked_warehouse_id' => $warehouse->id,
            ],
            'connection_settings' => [
                'username' => $this->faker->word(),
                'password' => $this->faker->md5(),
                'systemId' => $this->faker->word()
            ]
        ])->assertSuccessful();

        $response->assertJson(fn(AssertableJson $json) => $json->has('data.integration_settings.linked_warehouse_id')->etc());

    }
}
