<?php

namespace Modules\Veracore\Services\Fulfillments;

use App\Exceptions\SalesOrder\SalesOrderFulfillmentDispatchException;
use App\Models\SalesOrder;
use App\Models\SalesOrderFulfillment;
use App\Services\SalesOrder\Fulfillments\ShipmentDispatcher;
use Modules\Veracore\Services\VeracoreManager;
use Throwable;

class VeracoreDispatcher implements ShipmentDispatcher
{

    public function __construct(private readonly VeracoreManager $manager){}

    /**
     * @throws SalesOrderFulfillmentDispatchException|Throwable
     */
    public function dispatchFulfillmentToProvider(SalesOrderFulfillment $fulfillment)
    {
        // Only orders with delivery date should be submitted to Veracore
        if($this->manager->shouldOrdersHaveDeliveryByDate() && !$fulfillment->salesOrder->deliver_by_date){
            throw new SalesOrderFulfillmentDispatchException($fulfillment, 'Order must have deliver by date defined.');
        }

        // Create the order
        $this->manager->createFulfillment($fulfillment);

        $fulfillment->salesOrder()->update(
            ['fulfillment_status' => SalesOrder::FULFILLMENT_STATUS_AWAITING_TRACKING]
        );

        $now = now();

        $fulfillment->update(
            [
                'fulfilled_at'            => $now,
                'status'                  => SalesOrderFulfillment::STATUS_SUBMITTED,
            ]
        );

        $fulfillment->save();

    }


}