<?php

use Modules\Veracore\Http\Controllers\VeracoreIntegrationInstanceController;
use Modules\Veracore\Http\Controllers\VeracoreOrderController;


// Authenticated Veracore Routes.
Route::middleware('auth:sanctum')->group(function () {

    Route::prefix('veracore')->name('veracore.')->group(function () {
        Route::prefix('/integration-instances/{integration_instance}')->group(function(){
            Route::get('/', [VeracoreIntegrationInstanceController::class, 'show'])->name('integration-instances.show');
            Route::put('/', [VeracoreIntegrationInstanceController::class, 'update'])->name('integration-instances.update');
            Route::delete('/', [VeracoreIntegrationInstanceController::class, 'destroy'])->name('integration-instances.destroy');

        });

        Route::post('integration-instances', [VeracoreIntegrationInstanceController::class, 'store'])->name('integration-instances.store');

        // Routes for Power Users.
        Route::middleware('is_power_user')->group(function () {
            Route::put('update-order/{sales_order_fulfillment}', [VeracoreOrderController::class, 'updateOrderFromFulfillment']);
        });

    });

});