<soap:Envelope
        xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xmlns:xsd="http://www.w3.org/2001/XMLSchema">
    <soap:Header>
        <AuthenticationHeader xmlns="http://omscom/">
            <Username>{{$username}}</Username>
            <Password>{{$password}}</Password>
        </AuthenticationHeader>
    </soap:Header>
    <soap:Body>
        <AddOrder xmlns="http://omscom/">
            <order>
                <Header>
                    <ID>{{$id}}</ID>
                    <ReferenceNumber>{{$reference}}</ReferenceNumber>
                    <Comments>{{$comments}}</Comments>
                </Header>
                <Money></Money>
                <Payment></Payment>
                <OrderedBy>
                    <FirstName>{{ $customerFirstName }}</FirstName>
                    <Address1>{{ $streetAddress1 }}</Address1>
                    <Address2>{{ $streetAddress2 }}</Address2>
                    <Address3>{{ $streetAddress3 }}</Address3>
                    <City>{{ $city }}</City>
                    <State>{{ $state }}</State>
                    <PostalCode>{{ $postalCode }}</PostalCode>
                    <Country>{{ $country }}</Country>
                    <Phone>{{ $phone }}</Phone>
                    <Fax>{{ $fax }}</Fax>
                    <Email>{{ $email }}</Email>
                </OrderedBy>
                <ShipTo>
                    <OrderShipTo>
                        <Flag>OrderedBy</Flag>
                        <Key>1</Key>
                        <SpecialHandling>
                            <Description>{{ $requestedShippingMethod }}</Description>
                        </SpecialHandling>
                        <NeededBy>{{ $neededBy }}</NeededBy>
                        <ReleaseDate>{{ $releaseDate }}</ReleaseDate>
                    </OrderShipTo>
                </ShipTo>
                <BillTo>
                    <Flag>OrderedBy</Flag>
                </BillTo>
                <Offers>
                    @foreach ($orderLines as $orderLine)
                        <OfferOrdered>
                            <Offer>
                                <Header>
                                    <ID>{{ $orderLine['sku'] }}</ID>
                                </Header>
                            </Offer>
                            <Quantity>{{ $orderLine['quantity'] }}</Quantity>
                            <UnitPrice>{{ $orderLine['unit_price'] }}</UnitPrice>
                            <OrderShipTo>
                                <Key>1</Key>
                            </OrderShipTo>
                        </OfferOrdered>
                    @endforeach
                </Offers>
            </order>
        </AddOrder>
    </soap:Body>
</soap:Envelope>