<?php

namespace Modules\Veracore\Http\Controllers;

use App\Exceptions\SalesOrder\SalesOrderFulfillmentDispatchException;
use App\Http\Controllers\Controller;
use App\Models\SalesOrderFulfillment;
use Illuminate\Http\Response;
use Modules\Veracore\Services\VeracoreManager;
use Throwable;

class VeracoreOrderController extends Controller
{
    /**
     * @throws Throwable
     */
    public function updateOrderFromFulfillment(SalesOrderFulfillment $salesOrderFulfillment){
        $manager = app(VeracoreManager::class);
        try{
            $manager->updateOrderFromFulfillment($salesOrderFulfillment);
            return $this->response->setMessage('Order updated successfully');
        }catch (SalesOrderFulfillmentDispatchException $e){
            return $this->response->error(Response::HTTP_BAD_REQUEST)->setMessage($e->getMessage());
        }
        catch(\Exception $e){
            return $this->response->error()->setMessage($e->getMessage());
        }
    }

}