<?php

namespace Modules\Veracore\Data;

use App\Data\ShippingProviderIntegrationSettingsData;
use App\Data\UpdateShippingProviderIntegrationInstanceData;
use Illuminate\Http\Request;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Unique;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Support\Validation\References\RouteParameterReference;

class UpdateVeracoreIntegrationInstanceData extends UpdateShippingProviderIntegrationInstanceData
{

    /**
     * @param  string  $name
     * @param  int|Optional  $integration_id
     * @param  array|Optional  $connection_settings
     * @param  ShippingProviderIntegrationSettingsData|Optional  $integration_settings
     * @param  bool|Optional  $is_automatic_sync_enabled
     */
    public function __construct(
        #[Unique('integration_instances', ignore: new RouteParameterReference('integration_instance', 'id'))]
        public string $name,
        #[Exists('integrations', 'id')]
        public int|Optional $integration_id,
        public array|Optional $connection_settings,
        public ShippingProviderIntegrationSettingsData|Optional $integration_settings,
        public bool|Optional $is_automatic_sync_enabled,
    ) {
        parent::__construct(
            name: $name,
            integration_id: $integration_id,
            connection_settings: $connection_settings,
            integration_settings: $integration_settings,
            is_automatic_sync_enabled: $is_automatic_sync_enabled,
        );
    }

    /**
     * @param  Request  $request
     * @return UpdateVeracoreIntegrationInstanceData
     */
    public static function fromRequest(Request $request): UpdateVeracoreIntegrationInstanceData
    {
        return static::from([
            'name' => $request->input('name'),
            'integration_id' => $request->input('integration_id') ?? Optional::create(),
            'connection_settings' => $request->input('connection_settings') ?? Optional::create(),
            'integration_settings' => $request->has('integration_settings') ? VeracoreIntegrationSettingsData::from([
                'connection_name' => $request->input('integration_settings.connection_name'),
                'automate_fulfillment' => $request->input('integration_settings.automate_fulfillment') ?? false,
                'is_deliver_by_date_required' => $request->input('integration_settings.is_deliver_by_date_required') ?? false,
                'gift_card_note_sales_order_custom_field_id' => $request->input('integration_settings.gift_card_note_sales_order_custom_field_id') ?? null,
            ]) : Optional::create(),
            'is_automatic_sync_enabled' => $request->input('is_automatic_sync_enabled') ?? Optional::create(),
        ]);
    }

}