<?php

namespace Modules\Veracore\Data;

use App\Data\CreateShippingProviderIntegrationInstanceData;
use App\Data\ShippingProviderIntegrationSettingsData;
use Illuminate\Http\Request;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Unique;
use Spatie\LaravelData\Optional;

class CreateVeracoreIntegrationInstanceData extends CreateShippingProviderIntegrationInstanceData
{

    public function __construct(
        #[Unique('integration_instances')]
        public string $name,
        #[Exists('integrations', 'id')]
        public int $integration_id,
        public array|Optional $connection_settings,
        public ShippingProviderIntegrationSettingsData|Optional $integration_settings,
        public bool $is_automatic_sync_enabled = false,

    ) {
        parent::__construct(
            name: $name,
            integration_id: $integration_id,
            connection_settings: $connection_settings,
            integration_settings: $integration_settings,
            is_automatic_sync_enabled: $is_automatic_sync_enabled,
        );
    }

    public static function fromRequest(Request $request): CreateVeracoreIntegrationInstanceData
    {
        $parent = parent::fromRequest($request);
        return static::from([
            'name' => $parent->name,
            'integration_id' => $parent->integration_id,
            'connection_settings' => $parent->connection_settings,
            'integration_settings' => VeracoreIntegrationSettingsData::from([
                'connection_name' => $parent->integration_settings->connection_name,
                'linked_warehouse' => $parent->integration_settings->linked_warehouse,
                'automate_fulfillment' => $parent->integration_settings->automate_fulfillment,
                'is_deliver_by_date_required' => $request->input('is_deliver_by_date_required') ?? false,
                'gift_card_note_sales_order_custom_field_id' => $request->input('gift_card_note_sales_order_custom_field_id') ?? null,
            ]),
            'is_automatic_sync_enabled' => $parent->is_automatic_sync_enabled,
        ]);
    }

}