<?php

namespace Modules\Shopify\Tests\Feature\Managers;

use App\Models\AccountingTransaction;
use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Models\SalesChannel;
use App\Models\SalesOrder;
use App\Services\Accounting\AccountingTransactionManager;
use Illuminate\Foundation\Testing\WithFaker;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class ShopifyIntegrationInstanceManagerTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    private IntegrationInstance $shopifyIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();

        $this->shopifyIntegrationInstance = IntegrationInstance::factory([
            'name' => Integration::NAME_SHOPIFY,
            'is_automatic_sync_enabled' => true,
            'integration_settings' => [
                'sync_sales_order_invoices_to_accounting' => false,
            ],
        ])->has(SalesChannel::factory())
            ->create();
    }

    public function test_it_will_change_accounting_transactions_when_sync_sales_order_settings_changed(): void
    {
        $salesChannel = $this->shopifyIntegrationInstance->salesChannel;

        $salesOrder = SalesOrder::factory([
            'sales_channel_id' => $salesChannel->id,
        ])->create();

        app(AccountingTransactionManager::class)->sync();

        $this->assertDatabaseHas(AccountingTransaction::class, [
            'link_type' => SalesOrder::class,
            'link_id' => $salesOrder->id,
            'is_sync_enabled' => false,
        ]);

        $settings                                               = $this->shopifyIntegrationInstance->integration_settings;
        $settings['sync_sales_order_invoices_to_accounting']    = true;
        $this->shopifyIntegrationInstance->integration_settings = $settings;
        $this->shopifyIntegrationInstance->save();

        app(AccountingTransactionManager::class)->syncAccountingTransactionsSalesOrderIsSyncEnabledStatus($this->shopifyIntegrationInstance);

        $this->assertDatabaseHas(AccountingTransaction::class, [
            'link_type' => SalesOrder::class,
            'link_id' => $salesOrder->id,
            'is_sync_enabled' => true,
        ]);
    }
}