<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Modules\Shopify\Http\Controllers\ShopifyProductController;

Route::middleware('auth:sanctum')->group(function () {
    Route::prefix('/shopify/{shopifyIntegrationInstance}')->name('shopify.')->group(function () {
        Route::put('/products/map', [ShopifyProductController::class, 'mapProducts']);
        Route::post('/products/create-sku-products', [ShopifyProductController::class, 'createSkuProducts']);
    });
});
