<?php

namespace Modules\Shopify\Http\Requests\ShopifyProduct;

use Illuminate\Foundation\Http\FormRequest;

class MapShopifyProductRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'mapping' => 'required|array|min:1',
            // TODO: Need to use required_if to make sure that either amazon_product_id or amazon_seller_sku is provided
            'mapping.*.sales_channel_listing_id' => 'exists:shopify_products,variant_id',
            // 'mapping.*.seller_sku'  => 'exists:amazon_products,seller_sku',
            // TODO: Need to use required_if to make sure that either product_id or product_sku is provided
            // 'mapping.*.product_id'  => 'exists:products,id|nullable',
            'mapping.*.mapped_sku' => 'exists:products,sku|nullable',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
