<?php

namespace Modules\Shopify\Http\Controllers;

use App\DataTable\DataTable;
use App\DTO\ProductMappingDto;
use App\Http\Controllers\Controller;
use App\Jobs\Shopify\ShopifyCreateSkuProducts;
use App\Managers\ProductListingManager;
use App\Models\IntegrationInstance;
use App\Models\Shopify\ShopifyProduct;
use App\Repositories\DataImportMappingRepository;
use App\Response;
use Exception;
use Modules\Shopify\Http\Requests\ShopifyProduct\CreateSkuProductRequest;
use Modules\Shopify\Http\Requests\ShopifyProduct\MapShopifyProductRequest;
use Modules\Shopify\Managers\ShopifyProductManager;
use Throwable;

class ShopifyProductController extends Controller
{
    use DataTable;

    public function __construct(private readonly DataImportMappingRepository $dataImportMappingRepository)
    {
        parent::__construct();
    }

    /**
     * @throws Exception
     */
    public function mapProducts(MapShopifyProductRequest $request, IntegrationInstance $shopifyIntegrationInstance)
    {
        $mappings = collect($request->validated()['mapping'])->map(function ($mapping) {
            return ProductMappingDto::from([
                'sales_channel_listing_id' => $mapping['sales_channel_listing_id'],
                'mapped_sku' => $mapping['mapped_sku'],
                'document_type' => ShopifyProduct::class,
            ]);
        });

        (new ProductListingManager())->mapListings($mappings, app(ShopifyProduct::class), $shopifyIntegrationInstance);

        $this->response->addData(__('messages.success.create', ['resource' => 'product listings']));

        return $this->response;
    }

    // /**
    //  * @throws Throwable
    //  */
    // public function createSkuProducts(
    //     CreateSkuProductRequest $request,
    //     IntegrationInstance $shopifyIntegrationInstance
    // ): ?Response {
    //     //Validated data
    //     $data = $request->validated();

    //     //Persist mappings only if exists in request payload
    //     if (@$data['mapping']) {
    //         $this->dataImportMappingRepository->persistMapping($shopifyIntegrationInstance, 'listings',
    //             $data['mapping']);
    //     }

    //     //Create an instance for product manager
    //     $shopifyProductManager = (new ShopifyProductManager($shopifyIntegrationInstance));

    //     //If filters are present, get ids from filters
    //     if (! empty($data['filters'])) {
    //         $data['ids'] = $this->getIdsFromFilters(Product::class, $request);
    //     }

    //     //Create SKU products
    //     $shopifyProductManager->createSkuProducts((@$data['ids'] ?: []), $data['create_all_products']);

    //     return $this->response->setMessage('Added to queue, products will be created shortly.');
    // }

    public function createSkuProducts(
        CreateSkuProductRequest $request,
        IntegrationInstance $shopifyIntegrationInstance
    ): ?Response {
        //Validated data
        $data = $request->validated();

        //Persist mappings only if exists in request payload
        if (@$data['mapping']) {
            $this->dataImportMappingRepository->persistMapping($shopifyIntegrationInstance, 'listings',
                $data['mapping']);
        }

        //If filters are present, get ids from filters
        if (! empty($data['filters'])) {
            $data['ids'] = $this->getIdsFromFilters(ShopifyProduct::class, $request);
        }

        ShopifyCreateSkuProducts::dispatch($shopifyIntegrationInstance, $data['ids']);

        return $this->response->setMessage('Added to queue, products will be created shortly.');
    }

    protected function getModel()
    {
        // TODO: Implement getModel() method.
    }

    protected function getResource()
    {
        // TODO: Implement getResource() method.
    }
}
