<?php

declare(strict_types=1);

namespace Modules\ShipMyOrders\Tests\Unit\Services;

use Modules\ShipMyOrders\Managers\ShipMyOrdersShippingMethodMapperManager;
use Tests\TestCase;

/**
 * Class ShippingMethodMapperTest
 */
class ShippingMethodMapperTest extends TestCase
{
    public function test_lookup_succeeds_when_a_match_exists(): void
    {
        $ours = 'FedEx 2 Day';
        $theirs = 'FedEx Express 2nd Day';

        $result = ShipMyOrdersShippingMethodMapperManager::translateToShipMyOrdersShippingMethod(
            $ours
        );

        $this->assertEquals($theirs, $result);
    }

    public function test_lookup_fails_when_a_match_cannot_be_found(): void
    {
        $ours = 'Jerry';
        $theirs = '';

        $result = ShipMyOrdersShippingMethodMapperManager::translateToShipMyOrdersShippingMethod(
            $ours
        );

        $this->assertEquals($theirs, $result);
    }
}
