<?php

declare(strict_types=1);

namespace Modules\ShipMyOrders\Tests\Unit\DTO;

use Modules\ShipMyOrders\Data\ShipMyOrdersCredentialsData;
use Tests\TestCase;

/**
 * Class CredentialsDtoTest
 */
class CredentialsDtoTest extends TestCase
{
    protected string $username = 'sku';

    protected string $password = 'secret';

    protected string $clientId = 'a_client';

    public function test_instantiation(): void
    {
        $credentials = $this->getCredentials();

        $this->assertInstanceOf(
            ShipMyOrdersCredentialsData::class,
            $credentials
        );
    }

    public function test_getters_match_expected_values(): void
    {
        $credentials = $this->getCredentials();

        $this->assertEquals(
            $credentials->getUsername(),
            $this->username
        );

        $this->assertEquals(
            $credentials->getPassword(),
            $this->password
        );

        $this->assertEquals(
            $credentials->getClientId(),
            $this->clientId
        );
    }

    private function getCredentials(): ShipMyOrdersCredentialsData
    {
        $credentials = new ShipMyOrdersCredentialsData(
            $this->username,
            $this->password,
            $this->clientId
        );

        return $credentials;
    }
}
