<?php

use Modules\ShipMyOrders\Http\Controllers\ShipMyOrderInvoiceController;
use Modules\ShipMyOrders\Http\Controllers\ShipMyOrdersIntegrationInstanceController;
use Modules\ShipMyOrders\Http\Controllers\ShipMyOrdersInventoryController;
use Modules\ShipMyOrders\Http\Controllers\ShipMyOrdersInvoiceNominalCodeMappingRuleController;

// Authenticated SMO Routes.
Route::middleware('auth:sanctum')->group(function () {
    Route::prefix('shipmyorders')->name('shipmyorders.')->group(function () {
        Route::post('integration-instances', [ShipMyOrdersIntegrationInstanceController::class, 'store'])->name('integration-instances.store');
        Route::get('integration-instances/{integration_instance}', [ShipMyOrdersIntegrationInstanceController::class, 'show'])->name('integration-instances.show');
        Route::put('integration-instances/{integration_instance}', [ShipMyOrdersIntegrationInstanceController::class, 'update'])->name('integration-instances.update');
        Route::delete('integration-instances/{integration_instance}', [ShipMyOrdersIntegrationInstanceController::class, 'destroy'])->name('integration-instances.destroy');
        Route::prefix('inventory')->name('inventory.')->controller(ShipMyOrdersInventoryController::class)->group(function () {
            Route::post('refresh', 'refreshInventory')->name('refresh');
            Route::get('discrepancies', 'inventoryDiscrepancies')->name('discrepancies');
            Route::get('without-sku-products', 'withoutSkuProducts')->name('without-sku-products');
            Route::get('without-smo-inventory', 'withoutShipMyOrdersInventory')->name('without-smo-inventory');
        });
        Route::prefix('invoices')->name('invoices.')->group(function () {
            Route::put('{id}/archive', [ShipMyOrderInvoiceController::class, 'archive'])->name('archive');
            Route::put('{id}/unarchived', [ShipMyOrderInvoiceController::class, 'unarchived'])->name('unarchived');
            Route::put('archive', [ShipMyOrderInvoiceController::class, 'bulkArchive'])->name('bulk-archive');
            Route::put('unarchive', [ShipMyOrderInvoiceController::class, 'bulkUnArchive'])->name('bulk-unarchive');
            Route::delete('/', [ShipMyOrderInvoiceController::class, 'bulkDestroy'])->name('bulk-destroy');
            Route::post('deletable', [ShipMyOrderInvoiceController::class, 'isDeletable'])->name('deletable');
            Route::post('{invoice}/process', [ShipMyOrderInvoiceController::class, 'process'])->name('process');
            Route::post('{invoice}/unprocess', [ShipMyOrderInvoiceController::class, 'unprocess'])->name('unprocess');
            Route::post('process', [ShipMyOrderInvoiceController::class, 'bulkProcess'])->name('bulk-process');
            Route::post('unprocess', [ShipMyOrderInvoiceController::class, 'bulkUnprocess'])->name('bulk-unprocess');
            Route::post('process-all', [ShipMyOrderInvoiceController::class, 'processAll'])->name('process-all');
            Route::post('unprocess-all', [ShipMyOrderInvoiceController::class, 'unprocessAll'])->name('unprocess-all');
            Route::put('{shipMyOrdersInvoice}', [ShipMyOrderInvoiceController::class, 'update'])->name('update');
        });
        Route::resource('invoices/mapping-rules', ShipMyOrdersInvoiceNominalCodeMappingRuleController::class)->only(['index', 'store']);
        Route::resource('invoices', ShipMyOrderInvoiceController::class);
    });
});