<?php

namespace Modules\ShipMyOrders\Providers;

use App\Providers\ModuleServiceProvider;
use Modules\ShipMyOrders\Console\ShipMyOrdersRefreshTracking;

class ShipMyOrdersServiceProvider extends ModuleServiceProvider
{
    /**
     * @return void
     */
    public function boot(): void
    {
        parent::boot();

        $this->commands([
            ShipMyOrdersRefreshTracking::class
        ]);
    }

    public function register()
    {
        parent::register();
        $this->app->register(RouteServiceProvider::class);
    }

    /**
     * @return string
     */
    protected function moduleName(): string
    {
        return 'ShipMyOrders';
    }

    /**
     * @return string
     */
    protected function moduleNameLower(): string
    {
        return 'shipmyorders';
    }


}
