<?php

declare(strict_types=1);

namespace Modules\ShipMyOrders\Managers;

use App\Exceptions\SalesOrder\SalesOrderFulfillmentDispatchException;
use App\Models\SalesOrder;
use App\Models\SalesOrderFulfillment;
use App\Services\SalesOrder\Fulfillments\ShipmentDispatcher;
use Carbon\Carbon;

class ShipMyOrdersDispatchManager implements ShipmentDispatcher
{

    /**
     * @param  ShipMyOrdersOrderManager  $manager
     */
    public function __construct(
        private readonly ShipMyOrdersOrderManager $manager
    ){}

    /**
     * @param  SalesOrderFulfillment  $fulfillment
     * @return void
     * @throws SalesOrderFulfillmentDispatchException
     */
    public function dispatchFulfillmentToProvider(SalesOrderFulfillment $fulfillment): void
    {

        $this->manager->createFulfillment($fulfillment);

        $fulfillment->salesOrder()->update(
            ['fulfillment_status' => SalesOrder::FULFILLMENT_STATUS_AWAITING_TRACKING]
        );

        $now = new Carbon();

        $fulfillment->update(
            [
                'fulfilled_at' => $now,
                'status' => SalesOrderFulfillment::STATUS_SUBMITTED,
            ]
        );

    }
}
