<?php

namespace Modules\ShipMyOrders\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\ShipMyOrders\Entities\ShipMyOrdersInvoiceNominalCodeMappingRule;

/**
 * @mixin ShipMyOrdersInvoiceNominalCodeMappingRule
 */
class ShipMyOrdersInvoiceNominalCodeMappingRuleResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'nominal_code_id' => $this->nominal_code_id,
            $this->mergeWhen($this->relationLoaded('nominalCode'), [
                'nominal_code' => $this->nominalCode,
            ]),
            'sort_order' => $this->sort_order,
            'conditions' => $this->conditions,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}