<?php

namespace Modules\ShipMyOrders\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Response;
use Illuminate\Http\Request;
use Modules\ShipMyOrders\Data\ShipMyOrdersInvoiceNominalCodeMappingRuleData;
use Modules\ShipMyOrders\Http\Resources\ShipMyOrdersInvoiceNominalCodeMappingRuleResource;
use Modules\ShipMyOrders\Repositories\ShipMyOrdersInvoiceRepository;
use Throwable;

class ShipMyOrdersInvoiceNominalCodeMappingRuleController extends Controller
{
    public function __construct(private readonly ShipMyOrdersInvoiceRepository $invoices)
    {
        parent::__construct();
    }

    public function index(): Response
    {
        $rules = $this->invoices->getNominalCodesRules();

        return $this->response->addData(ShipMyOrdersInvoiceNominalCodeMappingRuleResource::collection($rules));
    }

    /**
     * @throws Throwable
     */
    public function store(Request $request): Response
    {
        $data = ShipMyOrdersInvoiceNominalCodeMappingRuleData::collection($request->get('rules'));

        $rules = $this->invoices->saveNominalCodesRules($data);

        return $this->response->addData($rules);
    }
}