<?php

namespace Modules\ShipMyOrders\Http\Controllers;

use App\Data\CreateShippingProviderIntegrationInstanceData;
use App\Data\ShippingProviderIntegrationInstanceData;
use App\Data\UpdateShippingProviderIntegrationInstanceData;
use App\Http\Controllers\ShippingProviderIntegrationInstanceController;
use App\Models\IntegrationInstance;
use App\Response;
use Throwable;

class ShipMyOrdersIntegrationInstanceController extends ShippingProviderIntegrationInstanceController
{

    /**
     * @param  IntegrationInstance  $integrationInstance
     * @return Response
     */
    public function show(IntegrationInstance $integrationInstance): Response
    {
        return $this->response->addData(
            ShippingProviderIntegrationInstanceData::from($integrationInstance)
        );
    }

    /**
     * @param  CreateShippingProviderIntegrationInstanceData  $data
     * @return Response
     */
    public function store(CreateShippingProviderIntegrationInstanceData $data): Response
    {
        return $this->response->addData(
            ShippingProviderIntegrationInstanceData::from($this->manager->createIntegrationInstance($data))
        );
    }

    /**
     * @param  IntegrationInstance  $integrationInstance
     * @param  UpdateShippingProviderIntegrationInstanceData  $data
     * @return Response
     */
    public function update(IntegrationInstance $integrationInstance, UpdateShippingProviderIntegrationInstanceData $data): Response
    {
        return $this->response->addData(
            ShippingProviderIntegrationInstanceData::from(
                $this->manager->updateIntegrationInstance($integrationInstance, $data)
            )
        );
    }

}
