<?php

namespace Modules\ShipMyOrders\Entities;

use App\Models\NominalCode;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\ShipMyOrders\Database\factories\ShipMyOrdersInvoiceNominalCodeMappingRuleFactory;

class ShipMyOrdersInvoiceNominalCodeMappingRule extends Model
{
    use HasFactory;

    protected $fillable = [
        'nominal_code_id',
        'conditions',
        'sort_order'
    ];

    protected $casts = [
        'conditions' => 'array',
    ];

    public function nominalCode(): BelongsTo
    {
        return $this->belongsTo(NominalCode::class);
    }

    public static function newFactory(): Factory
    {
        return ShipMyOrdersInvoiceNominalCodeMappingRuleFactory::new();
    }
}