<?php

namespace Modules\ShipMyOrders\Database\factories;

use App\Models\SalesOrderFulfillment;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\ShipMyOrders\Entities\ShipMyOrdersOrder;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<ShipMyOrdersOrder>
 */
class ShipMyOrdersOrderFactory extends Factory
{
    protected $model = ShipMyOrdersOrder::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'json_data' => [
                'ID' => $this->faker->numberBetween(100, 10000),
            ],
            'sku_fulfillment_id' => SalesOrderFulfillment::factory()
        ];
    }
}
