<?php

namespace Modules\ShipMyOrders\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\ShipMyOrders\Entities\ShipMyOrdersInvoice;
use Modules\ShipMyOrders\Entities\ShipMyOrdersInvoiceLine;

class ShipMyOrdersInvoiceLineFactory extends Factory
{
    protected $model = ShipMyOrdersInvoiceLine::class;

    public function definition(): array
    {
        return [
            'date' => Carbon::now(),
            'reference' => $this->faker->word(),
            'description' => $this->faker->text(),
            'amount' => $this->faker->randomFloat(4, 1000, 9999),
            'quantity' => $this->faker->randomNumber(rand(1, 2)),
            'subtotal' => $this->faker->randomFloat(4, 1000, 9999),
            'tax' => $this->faker->randomFloat(4, 1000, 9999),
            'total' => $this->faker->randomFloat(4, 1000, 9999),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ];
    }
}
