<?php

namespace Modules\ShipMyOrders\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\ShipMyOrders\Entities\ShipMyOrdersInvoice;

class ShipMyOrdersInvoiceFactory extends Factory
{
    protected $model = ShipMyOrdersInvoice::class;

    public function definition(): array
    {
        return [
            'invoice_number' => $this->faker->unique()->word(),
            'invoice_date' => Carbon::now(),
            'total' => $this->faker->randomFloat(4, 1000, 9999),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
