<?php

namespace Modules\ShipMyOrders\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\ShipMyOrders\Entities\ShipMyOrdersInventory;

class ShipMyOrdersInventoryFactory extends Factory
{
    protected $model = ShipMyOrdersInventory::class;

    public function definition(): array
    {
        return [
            'json_object' => [
                'SKU' => $this->faker->word(),
                'Desc' => $this->faker->word(),
                'Active' => $this->faker->boolean(),
                'Stock' => $this->faker->randomNumber(),
                'UPC' => $this->faker->word(),
                'Stock_NV' => $this->faker->randomNumber(),
            ],
        ];
    }
}
