<?php

namespace Modules\ShipMyOrders\Database\factories;

use App\Models\Integration;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\ShipMyOrders\Entities\ShipMyOrdersIntegrationInstance;

class ShipMyOrdersIntegrationInstanceFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = ShipMyOrdersIntegrationInstance::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'integration_id' => Integration::factory(),
            'name' => $this->faker->word(3),
            'connection_settings' => [
                'username' => 'abc',
                'password' => '123',
                'clientId' => 'fooBar',
                'defaultApiDomain' => 'https://shipmyorders-testing.net',
                'defaultApiPath' => '/RESTfm/SMORestAPI/layout/XML.xml?RFMformat=xmlall&RFMscript=',
            ],
            'integration_settings' => [],
        ];
    }
}
