<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('ship_my_orders_invoice_nominal_code_mapping_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('nominal_code_id')
                ->constrained('nominal_codes', 'id', 'smo_nc_mapping_rules_nc_id')
                ->onDelete('restrict');
            $table->json('conditions');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('ship_my_orders_invoice_nominal_code_mapping_rules');
    }
};
