<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('ship_my_orders_invoice_lines', function (Blueprint $table) {
            $table->foreignId('sales_order_fulfillment_id')->nullable()->after('ship_my_orders_invoice_id');
            $table->foreignId('financial_line_id')->nullable()->after('sales_order_fulfillment_id');
            $table->dateTime('processed_at')->nullable()->after('updated_at');
        });
    }

    public function down(): void
    {
        Schema::table('ship_my_orders_invoice_lines', function (Blueprint $table) {
            $table->dropColumn('sales_order_fulfillment_id');
            $table->dropColumn('financial_line_id');
            $table->dropColumn('processed_at');
        });
    }
};
