<?php

declare(strict_types=1);

namespace Modules\ShipMyOrders\Data;

use DateTimeInterface;

/**
 * Class ShipmentTracking
 */
class ShipMyOrdersShipmentTrackingData
{
    /*
     * Using DateTimeInterface to keep vendor interfaces out of
     * the domain layer.
     */
    public function __construct(
        protected string $trackingNumber,
        protected string $carrier,
        protected DateTimeInterface $shipDate
    ) {
    }

    public function getTrackingNumber(): string
    {
        return $this->trackingNumber;
    }

    public function getCarrier(): string
    {
        return $this->carrier;
    }

    public function getShipDate(): DateTimeInterface
    {
        return $this->shipDate;
    }
}
