<?php

namespace Modules\ShipMyOrders\Data;

use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class ShipMyOrdersInvoiceData extends Data
{
    public function __construct(
        public string $invoice_number,
        public string $invoice_date,
        public float $total,
        #[DataCollectionOf(ShipMyOrdersInvoiceLineData::class)]
        public DataCollection|Optional $lines,
    )
    {
    }
}
