<?php

declare(strict_types=1);

namespace Modules\ShipMyOrders\Data;

/**
 * Class CredentialsDto
 */
class ShipMyOrdersCredentialsData
{
    public function __construct(
        protected string $username,
        protected string $password,
        protected string $clientId
    ) {
    }

    public function getUsername(): string
    {
        return $this->username;
    }

    public function getPassword(): string
    {
        return $this->password;
    }

    public function getClientId(): string
    {
        return $this->clientId;
    }
}
