<?php

namespace Modules\Qbo\Tests;

use App\Models\AccountingTransaction;
use App\Models\PurchaseInvoice;
use App\Models\PurchaseOrder;
use App\Models\Supplier;
use Illuminate\Database\Eloquent\Collection;
use Modules\Qbo\Entities\QboPayment;

class QboTestingData
{
    public static function getAccessToken(): array
    {
        return [
            'refresh_token' => 'refresh token',
            'access_token' => 'access token',
            'token_type' => 'bearer',
            'x_refresh_token_expires_in' => time(),
            'expires_in' => time(),
        ];
    }

    public static function getAccounts(): array
    {
        return [
            'QueryResponse' => [
                'Account' => [
                    [
                        'Name' => 'Accounts Payable (A/P)',
                        'SubAccount' => false,
                        'FullyQualifiedName' => 'Accounts Payable (A/P)',
                        'Active' => true,
                        'Classification' => 'Liability',
                        'AccountType' => 'Accounts Payable',
                        'AccountSubType' => 'AccountsPayable',
                        'CurrentBalance' => -1602.67,
                        'CurrentBalanceWithSubAccounts' => -1602.67,
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '33',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-05-11T10:12:02-07:00',
                            'LastUpdatedTime' => '2023-05-18T13:10:36-07:00',
                        ],
                    ],
                    [
                        'Name' => 'Accounts Receivable (A/R)',
                        'SubAccount' => false,
                        'FullyQualifiedName' => 'Accounts Receivable (A/R)',
                        'Active' => true,
                        'Classification' => 'Asset',
                        'AccountType' => 'Accounts Receivable',
                        'AccountSubType' => 'AccountsReceivable',
                        'CurrentBalance' => 5281.52,
                        'CurrentBalanceWithSubAccounts' => 5281.52,
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '84',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-05-15T14:49:29-07:00',
                            'LastUpdatedTime' => '2023-05-18T13:16:17-07:00',
                        ],
                    ],
                    [
                        'Name' => 'Advertising',
                        'SubAccount' => false,
                        'FullyQualifiedName' => 'Advertising',
                        'Active' => true,
                        'Classification' => 'Expense',
                        'AccountType' => 'Expense',
                        'AccountSubType' => 'AdvertisingPromotional',
                        'CurrentBalance' => 0,
                        'CurrentBalanceWithSubAccounts' => 0,
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '7',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-05-10T14:42:07-07:00',
                            'LastUpdatedTime' => '2023-05-10T14:42:07-07:00',
                        ],
                    ],
                ],
                'startPosition' => 1,
                'maxResults' => 3,
            ],
            'time' => '2024-01-24T02:09:43.755-08:00',
        ];
    }

    public static function getTaxRates(): array
    {
        return [
            'QueryResponse' => [
                'TaxRate' => [
                    [
                        'Name' => 'AZ State tax',
                        'Description' => 'Sales Tax',
                        'Active' => true,
                        'RateValue' => 7.1,
                        'AgencyRef' => [
                            'value' => '1',
                        ],
                        'SpecialTaxType' => 'NONE',
                        'DisplayType' => 'ReadOnly',
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '1',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-05-17T12:17:04-07:00',
                            'LastUpdatedTime' => '2023-05-17T12:17:04-07:00',
                        ],
                    ],
                    [
                        'Name' => 'California',
                        'Description' => 'Sales Tax',
                        'Active' => true,
                        'RateValue' => 8,
                        'AgencyRef' => [
                            'value' => '2',
                        ],
                        'SpecialTaxType' => 'NONE',
                        'DisplayType' => 'ReadOnly',
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '3',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-05-17T12:17:04-07:00',
                            'LastUpdatedTime' => '2023-05-17T12:17:04-07:00',
                        ],
                    ],
                    [
                        'Name' => 'Tucson City',
                        'Description' => 'Sales Tax',
                        'Active' => true,
                        'RateValue' => 2,
                        'AgencyRef' => [
                            'value' => '1',
                        ],
                        'SpecialTaxType' => 'NONE',
                        'DisplayType' => 'ReadOnly',
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '2',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-05-17T12:17:04-07:00',
                            'LastUpdatedTime' => '2023-05-17T12:17:04-07:00',
                        ],
                    ],
                ],
                'startPosition' => 1,
                'maxResults' => 3,
                'totalCount' => 3,
            ],
            'time' => '2024-01-24T07:17:28.493-08:00',
        ];
    }

    public static function getTaxCodes(): array
    {
        return [
            'QueryResponse' => [
                'TaxCode' => [
                    [
                        'Name' => 'TAX',
                        'Description' => 'TAX',
                        'Taxable' => true,
                        'TaxGroup' => false,
                        'Id' => 'TAX',
                        'MetaData' => [
                            'CreateTime' => '2023-06-13T17:52:20-07:00',
                            'LastUpdatedTime' => '2023-06-13T17:52:20-07:00',
                        ],
                    ],
                    [
                        'Name' => 'NON',
                        'Description' => 'NON',
                        'Taxable' => false,
                        'TaxGroup' => false,
                        'Id' => 'NON',
                        'MetaData' => [
                            'CreateTime' => '2023-06-13T17:52:20-07:00',
                            'LastUpdatedTime' => '2023-06-13T17:52:20-07:00',
                        ],
                    ],
                    [
                        'Name' => 'CustomSalesTax',
                        'Description' => 'CustomSalesTax',
                        'Taxable' => true,
                        'TaxGroup' => true,
                        'Id' => 'CustomSalesTax',
                        'MetaData' => [
                            'CreateTime' => '2023-06-13T17:52:20-07:00',
                            'LastUpdatedTime' => '2023-06-13T17:52:20-07:00',
                        ],
                    ],
                    [
                        'Name' => 'California',
                        'Description' => 'California',
                        'Active' => true,
                        'Hidden' => false,
                        'Taxable' => true,
                        'TaxGroup' => true,
                        'SalesTaxRateList' => [
                            'TaxRateDetail' => [
                                [
                                    'TaxRateRef' => [
                                        'value' => '3',
                                        'name' => 'California',
                                    ],
                                    'TaxTypeApplicable' => 'TaxOnAmount',
                                    'TaxOrder' => 0,
                                ],
                            ],
                        ],
                        'PurchaseTaxRateList' => [
                            'TaxRateDetail' => [
                            ],
                        ],
                        'TaxCodeConfigType' => 'USER_DEFINED',
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '2',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-05-17T12:17:04-07:00',
                            'LastUpdatedTime' => '2023-05-17T12:17:04-07:00',
                        ],
                    ],
                    [
                        'Name' => 'Tucson',
                        'Description' => 'Tucson',
                        'Active' => true,
                        'Hidden' => false,
                        'Taxable' => true,
                        'TaxGroup' => true,
                        'SalesTaxRateList' => [
                            'TaxRateDetail' => [
                                [
                                    'TaxRateRef' => [
                                        'value' => '1',
                                        'name' => 'AZ State tax',
                                    ],
                                    'TaxTypeApplicable' => 'TaxOnAmount',
                                    'TaxOrder' => 0,
                                ],
                                [
                                    'TaxRateRef' => [
                                        'value' => '2',
                                        'name' => 'Tucson City',
                                    ],
                                    'TaxTypeApplicable' => 'TaxOnAmount',
                                    'TaxOrder' => 0,
                                ],
                            ],
                        ],
                        'PurchaseTaxRateList' => [
                            'TaxRateDetail' => [
                            ],
                        ],
                        'TaxCodeConfigType' => 'USER_DEFINED',
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '3',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-05-17T12:17:04-07:00',
                            'LastUpdatedTime' => '2023-05-17T12:17:04-07:00',
                        ],
                    ],
                ],
                'startPosition' => 1,
                'maxResults' => 5,
                'totalCount' => 5,
            ],
            'time' => '2024-05-12T01:28:20.665-07:00',
        ];
    }

    public static function getVendors(): array
    {
        return [
            'QueryResponse' => [
                'Vendor' => [
                    [
                        'Balance' => 0,
                        'Vendor1099' => false,
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '56',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2023-06-01T14:28:52-07:00',
                            'LastUpdatedTime' => '2023-06-01T14:28:52-07:00',
                        ],
                        'DisplayName' => "Bob's Burger Joint",
                        'PrintOnCheckName' => "Bob's Burger Joint",
                        'Active' => true,
                    ],
                ],
                'startPosition' => 1,
                'maxResults' => 1,
            ],
            'time' => '2024-02-11T01:55:18.439-08:00',
        ];
    }

    public static function getItems(): array
    {
        return [
            'QueryResponse' => [
                'Item' => [
                    'Name' => '1539242132198',
                    'Active' => true,
                    'FullyQualifiedName' => '1539242132198',
                    'Taxable' => false,
                    'UnitPrice' => 0,
                    'Type' => 'NonInventory',
                    'IncomeAccountRef' => [
                        'value' => '32',
                        'name' => 'Uncategorized Asset',
                    ],
                    'PurchaseCost' => 0,
                    'TrackQtyOnHand' => false,
                    'DeferredRevenue' => false,
                    'domain' => 'QBO',
                    'sparse' => false,
                    'Id' => '22',
                    'SyncToken' => '0',
                    'MetaData' => [
                        'CreateTime' => '2024-03-03T08:59:14-08:00',
                        'LastUpdatedTime' => '2024-03-03T08:59:14-08:00',
                    ],
                ],
                'time' => '2024-03-03T08:59:13.848-08:00',
            ],
        ];
    }

    public static function createPurchaseOrders(Collection $purchaseOrders): array
    {
        return [
            'BatchItemResponse' => $purchaseOrders->map(function (PurchaseOrder $purchaseOrder) {
                return [
                    'PurchaseOrder' => [
                        'POStatus' => 'Open',
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '291',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => $purchaseOrder->created_at->toIso8601ZuluString(),
                            'LastUpdatedTime' => $purchaseOrder->updated_at->toIso8601ZuluString(),
                        ],
                        'CustomField' => [
                        ],
                        'DocNumber' => $purchaseOrder->purchase_order_number,
                        'TxnDate' => $purchaseOrder->created_at->format('Y-m-d'),
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'LinkedTxn' => [
                        ],
                        'Line' => [
                            [
                                'Id' => '1',
                                'LineNum' => 1,
                                'Description' => 'Ex voluptatem temporibus modi dolores.',
                                'Amount' => 104,
                                'DetailType' => 'AccountBasedExpenseLineDetail',
                                'AccountBasedExpenseLineDetail' => [
                                    'AccountRef' => [
                                        'value' => '12',
                                        'name' => 'Legal & Professional Fees',
                                    ],
                                    'BillableStatus' => 'NotBillable',
                                    'TaxCodeRef' => [
                                        'value' => 'NON',
                                    ],
                                ],
                            ],
                        ],
                        'VendorRef' => [
                            'value' => '46',
                            'name' => 'Norton Lumber and Building Materials',
                        ],
                        'APAccountRef' => [
                            'value' => '33',
                            'name' => 'Accounts Payable (A/P)',
                        ],
                        'TotalAmt' => 104,
                    ],
                    'bId' => 'bid0',
                ];
            })->toArray(),
            'time' => '2024-02-14T04:46:40.367-08:00',
        ];
    }

    public static function createBills(Collection $purchaseInvoices): array
    {
        return [
            'BatchItemResponse' => $purchaseInvoices->map(function (PurchaseInvoice $purchaseInvoice) {
                return [
                    'Bill' => [
                        'POStatus' => 'Open',
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '291',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => $purchaseInvoice->created_at->toIso8601ZuluString(),
                            'LastUpdatedTime' => $purchaseInvoice->updated_at->toIso8601ZuluString(),
                        ],
                        'CustomField' => [
                        ],
                        'DocNumber' => $purchaseInvoice->supplier_invoice_number,
                        'TxnDate' => $purchaseInvoice->created_at->format('Y-m-d'),
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'LinkedTxn' => [
                        ],
                        'Line' => [
                            [
                                'Id' => '1',
                                'LineNum' => 1,
                                'Description' => 'Ex voluptatem temporibus modi dolores.',
                                'Amount' => 104,
                                'DetailType' => 'AccountBasedExpenseLineDetail',
                                'AccountBasedExpenseLineDetail' => [
                                    'AccountRef' => [
                                        'value' => '12',
                                        'name' => 'Legal & Professional Fees',
                                    ],
                                    'BillableStatus' => 'NotBillable',
                                    'TaxCodeRef' => [
                                        'value' => 'NON',
                                    ],
                                ],
                            ],
                        ],
                        'VendorRef' => [
                            'value' => '46',
                            'name' => 'Norton Lumber and Building Materials',
                        ],
                        'APAccountRef' => [
                            'value' => '33',
                            'name' => 'Accounts Payable (A/P)',
                        ],
                        'TotalAmt' => 104,
                    ],
                    'bId' => 'bid0',
                ];
            })->toArray(),
            'time' => '2024-02-14T04:46:40.367-08:00',
        ];
    }

    public static function createVendor(Supplier $supplier): array
    {
        return [
            'Vendor' => [
                'Balance' => 0,
                'Vendor1099' => false,
                'CurrencyRef' => [
                    'value' => 'USD',
                    'name' => 'United States Dollar',
                ],
                'domain' => 'QBO',
                'sparse' => false,
                'Id' => $supplier->id,
                'SyncToken' => '0',
                'MetaData' => [
                    'CreateTime' => '2024-02-15T07:25:38-08:00',
                    'LastUpdatedTime' => '2024-02-15T07:25:38-08:00',
                ],
                'DisplayName' => $supplier->name,
                'PrintOnCheckName' => 'Keagan Mitchellsssskjhakjsdhaskjh',
                'Active' => true,
            ],
            'time' => '2024-02-15T07:25:38.223-08:00',
        ];
    }

    public static function createCustomer(string $displayName): array
    {
        return [
            'Customer' => [
                'Taxable' => true,
                'Job' => false,
                'BillWithParent' => false,
                'Balance' => 0,
                'BalanceWithJobs' => 0,
                'CurrencyRef' => [
                    'value' => 'USD',
                    'name' => 'United States Dollar',
                ],
                'PreferredDeliveryMethod' => 'Print',
                'domain' => 'QBO',
                'sparse' => false,
                'Id' => '110',
                'SyncToken' => '0',
                'MetaData' => [
                    'CreateTime' => '2024-02-24T23:13:47-08:00',
                    'LastUpdatedTime' => '2024-02-24T23:13:47-08:00',
                ],
                'FullyQualifiedName' => $displayName,
                'DisplayName' => $displayName,
                'PrintOnCheckName' => $displayName,
                'Active' => true,
                'DefaultTaxCodeRef' => [
                    'value' => '2',
                ],
            ],
            'time' => '2024-02-24T23:13:47.443-08:00',
        ];
    }

    public static function createItem(string $name): array
    {
        return [
            'Item' => [
                'Name' => $name,
                'Active' => true,
                'FullyQualifiedName' => $name,
                'Taxable' => false,
                'UnitPrice' => 0,
                'Type' => 'NonInventory',
                'IncomeAccountRef' => [
                    'value' => '32',
                    'name' => 'Uncategorized Asset',
                ],
                'ExpenseAccountRef' => [
                    'value' => '33',
                    'name' => 'Expense Uncategorized Asset',
                ],
                'PurchaseCost' => 0,
                'TrackQtyOnHand' => false,
                'DeferredRevenue' => false,
                'domain' => 'QBO',
                'sparse' => false,
                'Id' => '22',
                'SyncToken' => '0',
                'MetaData' => [
                    'CreateTime' => '2024-03-03T08:59:14-08:00',
                    'LastUpdatedTime' => '2024-03-03T08:59:14-08:00',
                ],
            ],
            'time' => '2024-02-24T23:13:47.443-08:00',
        ];
    }

    public static function createInvoices(Collection $salesOrders): array
    {
        return [
            'BatchItemResponse' => [
                [
                    'Invoice' => [
                        'AllowIPNPayment' => false,
                        'AllowOnlinePayment' => false,
                        'AllowOnlineCreditCardPayment' => false,
                        'AllowOnlineACHPayment' => false,
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '303',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => $salesOrders->first()->created_at->toIso8601ZuluString(),
                            'LastUpdatedTime' => $salesOrders->first()->created_at->toIso8601ZuluString(),
                        ],
                        'CustomField' => [
                        ],
                        'DocNumber' => $salesOrders->first()->sales_order_number,
                        'TxnDate' => $salesOrders->first()->created_at->format('Y-m-d'),
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'LinkedTxn' => [
                        ],
                        'Line' => [
                            [
                                'Id' => '1',
                                'LineNum' => 1,
                                'Amount' => 111,
                                'DetailType' => 'SalesItemLineDetail',
                                'SalesItemLineDetail' => [
                                    'ItemRef' => [
                                        'value' => '1',
                                        'name' => 'Services',
                                    ],
                                    'TaxCodeRef' => [
                                        'value' => 'NON',
                                    ],
                                ],
                            ],
                            [
                                'Amount' => 111,
                                'DetailType' => 'SubTotalLineDetail',
                                'SubTotalLineDetail' => [
                                ],
                            ],
                        ],
                        'TxnTaxDetail' => [
                            'TotalTax' => 0,
                        ],
                        'CustomerRef' => [
                            'value' => '103',
                            'name' => 'Dr. Hilda Hickle',
                        ],
                        'DueDate' => '2024-03-25',
                        'TotalAmt' => 111,
                        'ApplyTaxAfterDiscount' => false,
                        'PrintStatus' => 'NeedToPrint',
                        'EmailStatus' => 'NotSet',
                        'Balance' => 111,
                    ],
                    'bId' => 'bid0',
                ],
            ],
            'time' => '2024-02-24T23:04:57.183-08:00',
        ];
    }

    public static function createPayments(Collection $qboRecords, Collection $payments): array
    {
        $qboInvoice = $qboRecords->first();
        $payment = $payments->first();

        return [
            'BatchItemResponse' => [
                [
                    'Payment' => [
                        'PaymentRefNum' => $payment->external_reference,
                        'CustomerRef' => [
                            'value' => $qboInvoice->json_object['CustomerRef']['value'],
                            'name' => $qboInvoice->json_object['CustomerRef']['name'],
                        ],
                        'DepositToAccountRef' => [
                            'value' => '4',
                        ],
                        'TotalAmt' => 12,
                        'UnappliedAmt' => 0,
                        'ProcessPayment' => false,
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '344',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => $qboInvoice->json_object['MetaData']['CreateTime'],
                            'LastUpdatedTime' => $qboInvoice->json_object['MetaData']['LastUpdatedTime'],
                        ],
                        'TxnDate' => $qboInvoice->json_object['TxnDate'],
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'Line' => [
                            [
                                'Amount' => 12,
                                'LinkedTxn' => [
                                    [
                                        'TxnId' => $qboInvoice->QboId,
                                        'TxnType' => 'Invoice',
                                    ],
                                ],
                                'LineEx' => [
                                    'any' => [
                                        [
                                            'name' => '{http://schema.intuit.com/finance/v3}NameValue',
                                            'declaredType' => 'com.intuit.schema.finance.v3.NameValue',
                                            'scope' => 'javax.xml.bind.JAXBElementGlobalScope',
                                            'value' => [
                                                'Name' => 'txnId',
                                                'Value' => $qboInvoice->QboId,
                                            ],
                                            'nil' => false,
                                            'globalScope' => true,
                                            'typeSubstituted' => false,
                                        ],
                                        [
                                            'name' => '{http://schema.intuit.com/finance/v3}NameValue',
                                            'declaredType' => 'com.intuit.schema.finance.v3.NameValue',
                                            'scope' => 'javax.xml.bind.JAXBElementGlobalScope',
                                            'value' => [
                                                'Name' => 'txnOpenBalance',
                                                'Value' => '12.00',
                                            ],
                                            'nil' => false,
                                            'globalScope' => true,
                                            'typeSubstituted' => false,
                                        ],
                                        [
                                            'name' => '{http://schema.intuit.com/finance/v3}NameValue',
                                            'declaredType' => 'com.intuit.schema.finance.v3.NameValue',
                                            'scope' => 'javax.xml.bind.JAXBElementGlobalScope',
                                            'value' => [
                                                'Name' => 'txnReferenceNumber',
                                                'Value' => $qboInvoice->DocNumber,
                                            ],
                                            'nil' => false,
                                            'globalScope' => true,
                                            'typeSubstituted' => false,
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                    'bId' => 'bid0',
                ],
            ],
            'time' => '2024-02-25T02:18:08.885-08:00',
        ];
    }

    public static function deletePayments(Collection $qboPayments): array
    {
        return [
            'BatchItemResponse' => $qboPayments->map(function (QboPayment $qboPayment) {
                return [
                    'Payment' => [
                        'domain' => 'QBO',
                        'status' => 'Deleted',
                        'Id' => $qboPayment->QboId,
                    ],
                    'bId' => 'bid0',
                ];
            })->toArray(),
            'time' => '2024-02-25T02:18:08.885-08:00',
        ];
    }

    public static function createJournals(AccountingTransaction $stockTakeAccountingTransaction): array
    {
        return [
            'BatchItemResponse' => [
                [
                    'JournalEntry' => [
                        'Adjustment' => false,
                        'TotalAmt' => 0,
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => $stockTakeAccountingTransaction->id,
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2024-03-25T11:56:37-07:00',
                            'LastUpdatedTime' => '2024-03-25T11:56:37-07:00',
                        ],
                        'DocNumber' => $stockTakeAccountingTransaction->id,
                        'TxnDate' => '2024-03-25',
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'Line' => [
                            [
                                'Id' => '0',
                                'Description' => 'Vel eum aliquam sed incidunt adipisci laboriosam.',
                                'Amount' => 157,
                                'DetailType' => 'JournalEntryLineDetail',
                                'JournalEntryLineDetail' => [
                                    'PostingType' => 'Debit',
                                    'AccountRef' => [
                                        'value' => '7',
                                        'name' => 'Advertising',
                                    ],
                                ],
                            ],
                            [
                                'Id' => '1',
                                'Description' => 'Vel eum aliquam sed incidunt adipisci laboriosam.',
                                'Amount' => 157,
                                'DetailType' => 'JournalEntryLineDetail',
                                'JournalEntryLineDetail' => [
                                    'PostingType' => 'Credit',
                                    'AccountRef' => [
                                        'value' => '7',
                                        'name' => 'Advertising',
                                    ],
                                ],
                            ],
                            [
                                'Id' => '2',
                                'Description' => 'Rem eligendi esse occaecati excepturi praesentium ut et.',
                                'Amount' => 165,
                                'DetailType' => 'JournalEntryLineDetail',
                                'JournalEntryLineDetail' => [
                                    'PostingType' => 'Debit',
                                    'AccountRef' => [
                                        'value' => '7',
                                        'name' => 'Advertising',
                                    ],
                                ],
                            ],
                            [
                                'Id' => '3',
                                'Description' => 'Rem eligendi esse occaecati excepturi praesentium ut et.',
                                'Amount' => 165,
                                'DetailType' => 'JournalEntryLineDetail',
                                'JournalEntryLineDetail' => [
                                    'PostingType' => 'Credit',
                                    'AccountRef' => [
                                        'value' => '7',
                                        'name' => 'Advertising',
                                    ],
                                ],
                            ],
                            [
                                'Id' => '4',
                                'Description' => 'Suscipit aut quis iusto voluptatibus quo.',
                                'Amount' => 119,
                                'DetailType' => 'JournalEntryLineDetail',
                                'JournalEntryLineDetail' => [
                                    'PostingType' => 'Debit',
                                    'AccountRef' => [
                                        'value' => '7',
                                        'name' => 'Advertising',
                                    ],
                                ],
                            ],
                            [
                                'Id' => '5',
                                'Description' => 'Suscipit aut quis iusto voluptatibus quo.',
                                'Amount' => 119,
                                'DetailType' => 'JournalEntryLineDetail',
                                'JournalEntryLineDetail' => [
                                    'PostingType' => 'Credit',
                                    'AccountRef' => [
                                        'value' => '7',
                                        'name' => 'Advertising',
                                    ],
                                ],
                            ],
                        ],
                        'TxnTaxDetail' => [
                        ],
                    ],
                    'bId' => 'bid1',
                ],
            ],
            'time' => '2024-03-25T11:56:37.025-07:00',
        ];
    }

    public static function createCreditMemos(Collection $salesCredits): array
    {
        $saleCredit = $salesCredits->first();

        return [
            'BatchItemResponse' => [
                [
                    'CreditMemo' => [
                        'RemainingCredit' => 17,
                        'domain' => 'QBO',
                        'sparse' => false,
                        'Id' => '524',
                        'SyncToken' => '0',
                        'MetaData' => [
                            'CreateTime' => '2024-03-03T07:49:06-08:00',
                            'LastUpdatedTime' => '2024-03-03T07:49:06-08:00',
                        ],
                        'CustomField' => [
                        ],
                        'DocNumber' => $saleCredit->sales_credit_number,
                        'TxnDate' => '2024-03-03',
                        'CurrencyRef' => [
                            'value' => 'USD',
                            'name' => 'United States Dollar',
                        ],
                        'Line' => [
                            [
                                'Id' => '1',
                                'LineNum' => 1,
                                'Amount' => 17,
                                'DetailType' => 'SalesItemLineDetail',
                                'SalesItemLineDetail' => [
                                    'ItemRef' => [
                                        'value' => '1',
                                        'name' => 'Services',
                                    ],
                                    'TaxCodeRef' => [
                                        'value' => 'NON',
                                    ],
                                ],
                            ],
                            [
                                'Amount' => 17,
                                'DetailType' => 'SubTotalLineDetail',
                                'SubTotalLineDetail' => [
                                ],
                            ],
                        ],
                        'TxnTaxDetail' => [
                            'TotalTax' => 0,
                        ],
                        'CustomerRef' => [
                            'value' => '266',
                            'name' => 'Dr. Glenna Flatley DVM',
                        ],
                        'TotalAmt' => 17,
                        'ApplyTaxAfterDiscount' => false,
                        'PrintStatus' => 'NeedToPrint',
                        'EmailStatus' => 'NotSet',
                        'Balance' => 17,
                    ],
                    'bId' => 'bid1',
                ],
            ],
            'time' => '2024-03-03T07:49:05.621-08:00',
        ];
    }
}
